package gov.va.genisis2.exceptions;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

import gov.va.genisis2.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class Genisis2ExceptionControllerAdviceTest.
 * 
 * Description: In this Genisis2ExceptionControllerAdviceTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 * 
 */
public class Genisis2ExceptionControllerAdviceTest extends AbstractMockMvcTests {
	
	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(Genisis2ExceptionControllerAdviceTest.class);

	/**
	 * Test genisis 2 exception controller advice handler.
	 *
	 * @throws Exception the exception
	 */
	@Test
	public void TestGenisis2ExceptionControllerAdviceHandler() throws Exception {
		LOGGER.info("**********JunitTEST for Exception handler**********");
		
		Genisis2ExceptionControllerAdvice ex =  new Genisis2ExceptionControllerAdvice();
		
		Genisis2RestException exception = new Genisis2RestException("errorMessageTestOne");

		ResponseEntity<ErrorResponse> ent = ex.exceptionHandler(exception);
		
		Assert.assertNotNull(ent.getStatusCode());

		LOGGER.info("********** end of Junit TEST for Exception handler**********  " + ent.getStatusCode());

	}
}